/**
 *  Copyright: (c) 2016-2017 FileMaker, Inc. All rights reserved.
 *
 *  FILEMAKER CONFIDENTIAL
 *  This file includes unpublished proprietary source code of FileMaker,
 *  Inc. The copyright notice above does not evidence any actual or
 *  intended publication of such source code.
 */

/* 
DO NOT EDIT THIS FILE UNLESS INDICATED

This JavaScript file contains necessary functions to provide a custom home page for your FileMaker WebDirect users.
*/

var kCustomHomeParam = 'homeurl';
var kCustomLoginParam = 'homelogin';
var kLoginErrorCode = 'loginerr';
var kLoginDB = 'db';
var kParamScript = 'script';

var webdUrl = '/fmi/webd/';
var scriptQuery = '';

/* IMPORTANT - this has to be called at the BEGINNING of your body's onload() function */
function onLoadEnter() {
	scriptQuery = '';
	
	if (getParameter(kParamScript) != null) {
		scriptQuery = kParamScript + '=' + getParameter(kParamScript);
	}
}

/* IMPORTANT - this has to be called at the END of your body's onload() function */
function onLoadExit() {
	var	url = window.location.href;
	url = url.split(/[?#]/)[0];

	window.history.replaceState(null, null, url);
}

/* For the actual database login */
function openDatabase(dbName, user, pwd, guest, customLogin) {
	var url = document.referrer;
	
	if (url == null || url == '') {
		url = window.location.href.split('?')[0];
	}
	
	if (url.indexOf(webdUrl) == -1) {
		url = webdUrl + dbName + '?' + kCustomHomeParam + '=' + url;
	}
	
	var node, form = document.createElement('form');
	form.style.display = 'none';
	form.action = url;
	form.method = 'POST';
	form.target = '_self';

	node = document.createElement('input');
	node.type = 'text';
	node.name = 'user';
	node.value = user;
	form.appendChild(node.cloneNode());

	node = document.createElement('input');
	node.type = 'text';
	node.name = 'pwd';
	node.value = pwd;
	form.appendChild(node.cloneNode());

	if (scriptQuery != '' && url.indexOf(scriptQuery) == -1)
		form.action += scriptQuery;
		
	if (guest == true && url.indexOf('guest=1') == -1) {
		form.action += '&guest=1';
	}
	if (customLogin == true && url.indexOf(kCustomLoginParam + '=1') == -1) {
		form.action += ('&' + kCustomLoginParam + '=1');
	}

	document.body.appendChild(form);
	form.submit();
	document.body.removeChild(form);
}

function getLoginErrorCode() {
	return getParameter(kLoginErrorCode);
}

function getDatabaseNameFromLoginError() {
	return getParameter(kLoginDB);
}

/* Get a specific parameter value from the query string */
function getParameter(name) {
    var url = window.location.href;
    name = name.replace(/[\[\]]/g, '\\$&');
    var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
        results = regex.exec(url);
    if (!results) return null;
    if (!results[2]) return '';

    return decodeURIComponent(results[2].replace(/\+/g, ' '));
}
